/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.blay09.mods.balm.forge.world.BiomeModification;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBalmWorldGen
implements BalmWorldGen {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();
    private static final List<BiomeModification> biomeModifications = new ArrayList<BiomeModification>();

    public ForgeBalmWorldGen() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public <T extends Feature<?>> DeferredObject<T> registerFeature(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(ForgeRegistries.FEATURES, identifier.m_135827_());
        RegistryObject registryObject = register.register(identifier.m_135815_(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public <FC extends FeatureConfiguration, F extends Feature<FC>, T extends ConfiguredFeature<FC, F>> DeferredObject<T> registerConfiguredFeature(ResourceLocation identifier, Supplier<F> featureSupplier, Supplier<FC> configurationSupplier) {
        DeferredObject<ConfiguredFeature> deferredObject = new DeferredObject<ConfiguredFeature>(identifier, () -> {
            Holder configuredFeature = FeatureUtils.m_206488_((String)identifier.toString(), (Feature)((Feature)featureSupplier.get()), (FeatureConfiguration)((FeatureConfiguration)configurationSupplier.get()));
            return (ConfiguredFeature)configuredFeature.m_203334_();
        });
        this.getActiveRegistrations().configuredFeatures.add(deferredObject);
        return deferredObject;
    }

    @Override
    public <T extends PlacedFeature> DeferredObject<T> registerPlacedFeature(ResourceLocation identifier, Supplier<ConfiguredFeature<?, ?>> configuredFeatureSupplier, PlacementModifier ... placementModifiers) {
        DeferredObject<PlacedFeature> deferredObject = new DeferredObject<PlacedFeature>(identifier, () -> {
            Holder placedFeature = PlacementUtils.m_206513_((String)identifier.toString(), (Holder)Holder.m_205709_((Object)((ConfiguredFeature)configuredFeatureSupplier.get())), (PlacementModifier[])placementModifiers);
            return (PlacedFeature)placedFeature.m_203334_();
        });
        this.getActiveRegistrations().placedFeatures.add(deferredObject);
        return deferredObject;
    }

    @Override
    public <T extends PlacementModifierType<?>> DeferredObject<T> registerPlacementModifier(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredObject<PlacementModifierType> deferredObject = new DeferredObject<PlacementModifierType>(identifier, () -> {
            PlacementModifierType placementModifierType = (PlacementModifierType)supplier.get();
            Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)identifier, (Object)placementModifierType);
            return placementModifierType;
        });
        this.getActiveRegistrations().placementModifiers.add(deferredObject);
        return deferredObject;
    }

    @Override
    public void addFeatureToBiomes(BiomePredicate biomePredicate, GenerationStep.Decoration step, ResourceLocation placedFeatureIdentifier) {
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)placedFeatureIdentifier);
        biomeModifications.add(new BiomeModification(biomePredicate, step, (ResourceKey<PlacedFeature>)resourceKey));
    }

    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent event) {
        for (BiomeModification biomeModification : biomeModifications) {
            if (!biomeModification.getBiomePredicate().test(event.getName(), event.getCategory(), event.getClimate().f_47680_, event.getClimate().f_47681_, event.getClimate().f_47683_)) continue;
            BuiltinRegistries.f_194653_.m_203636_(biomeModification.getConfiguredFeatureKey()).ifPresent(placedFeature -> event.getGeneration().m_204201_(biomeModification.getStep(), placedFeature));
        }
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        public final List<DeferredObject<?>> configuredFeatures = new ArrayList();
        public final List<DeferredObject<?>> placedFeatures = new ArrayList();
        public final List<DeferredObject<?>> placementModifiers = new ArrayList();

        private Registrations() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                this.configuredFeatures.forEach(DeferredObject::resolve);
                this.placedFeatures.forEach(DeferredObject::resolve);
            });
        }

        @SubscribeEvent
        public void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            this.placementModifiers.forEach(DeferredObject::resolve);
        }
    }
}

